/*
  Bombing Run Hud.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
*/
 
//note: This must extend UTCTFHUD because UTPlayerController.ShowMap depends on this to show base locator arrows when pressing F2
class UTBRHUD extends UTCTFHUD;

var UTBRBall TheBall;

simulated function PostBeginPlay()
{
    Super(UTTeamHUD).PostBeginPlay();

    SetBall();  

    SetTimer(1.0, True);
}

simulated function DebugHud(string s)
{
    if ((UTBRGame(WorldInfo.Game) != none) && UTBRGame(WorldInfo.Game).DebugHud)
    {
        UTBRGame(WorldInfo.Game).SendDebugMessage(UTOwnerPRI.GetPlayerAlias() $ " DebugHud: " $ s); 
    } 
}

//copied from UTHud
exec function SetShowScores(bool bNewValue)
{
	local UTGameReplicationInfo GRI;

    //allow player to control scoreboard during map switch.
    //along with it being annoying not being able to close the scoreboard,
    //this will also help to eliminate the issue where sometimes scoreboard
    //stays stuck on screen after map switch.
	//if (!bNewValue && WorldInfo.IsInSeamlessTravel() )
	//{
	//	return;
	//}

	GRI = UTGameReplicationInfo(WorldInfo.GRI);

	if ( GRI != none )
	{
        //sometimes scoreboard stays stuck on player screen after map switch.
        //looking at UTGameReplicationInfo.ShowScores, looks like Host var is the cause.
        if ((GRI.ScoreboardScene != none) && (GRI.ScoreboardScene.Host != UTPlayerOwner))
        {
            GRI.ScoreboardScene.Host = UTPlayerOwner;
        }
        	
		GRI.ShowScores(bNewValue, UTPlayerOwner, ScoreboardSceneTemplate);
	}	
}

//modified from base class to display enhanced spectator camera view target
function DrawGameHud()
{
    local float xl, yl, ypos;
    local float TempResScale;
    local Pawn P;
    local int i, len;
    local string s;
    local UTBRPlayerManager playerManager;
    local PlayerReplicationInfo pri;

    if ((UTBRGame(WorldInfo.Game) != none) && UTBRGame(WorldInfo.Game).DebugHud)
    {
        DebugHud("DrawGameHud1 " $ " PlayerOwner=" $ PlayerOwner $ " PlayerOwner.Pawn=" $ UTPlayerController(PlayerOwner).Pawn $ " PlayerOwner.Pawn.Weapon=" $ UTPlayerController(PlayerOwner).Pawn.Weapon);
    }
                
    // Draw any spectator information
    if (UTOwnerPRI != None)
    {   
        if (UTOwnerPRI.bOnlySpectator || UTPlayerOwner.IsInState('Spectating'))
        {
            P = Pawn(UTPlayerOwner.ViewTarget);
                   
            //modified for br   
            
            playerManager = UTBRGame(WorldInfo.Game).LocalPlayerManager;
              
            s = "";
            if ((playerManager != none) && (playerManager.SpectatorViewTarget != none) && 
                (playerManager.SpectatorViewTarget != PlayerOwner))
            {
                s = playerManager.SpectatorViewTarget.GetHumanReadableName();

                pri = PlayerReplicationInfo(playerManager.SpectatorViewTarget);
                p = Pawn(playerManager.SpectatorViewTarget);
                if ((p != none) && (p.PlayerReplicationInfo != none))
                { 
                    pri = p.PlayerReplicationInfo;
                }
                                
                if (pri != none)
                {
                   s = pri.GetPlayerAlias();
                }
            }

            if (s != "")
            {
                s = " - " $ s;
            }
            DisplayHUDMessage(SpectatorMessage $ s , 0.05, 0.15);
        }
        else if ( UTOwnerPRI.bIsSpectator )
        {
            if (UTGRI != None && UTGRI.bMatchHasBegun)
            {
                DisplayHUDMessage(PressFireToBegin);
            }
            else
            {
                DisplayHUDMessage(WaitingForMatch);
            }

        }
        else if ( UTPlayerOwner.IsDead() )
        {
            DisplayHUDMessage( UTPlayerOwner.bFrozen ? DeadMessage : FireToRespawnMessage );
        }
    }

    // Draw the Warmup if needed
    if (UTGRI != None && UTGRI.bWarmupRound)
    {
        Canvas.Font = GetFontSizeIndex(2);
        Canvas.DrawColor = WhiteColor;
        Canvas.StrLen(WarmupString, XL, YL);
        Canvas.SetPos((Canvas.ClipX - XL) * 0.5, Canvas.ClipY * 0.175);
        Canvas.DrawText(WarmupString);
    }

    if ( bCrosshairOnFriendly )
    {
        // verify that crosshair trace might hit friendly
        bGreenCrosshair = CheckCrosshairOnFriendly();
        bCrosshairOnFriendly = false;
    }
    else
    {
        bGreenCrosshair = false;
    }

    if ( bShowDebugInfo && PawnOwner != none )
    {
        Canvas.Font = GetFontSizeIndex(0);
        Canvas.DrawColor = ConsoleColor;
        Canvas.StrLen("X", XL, YL);
        YPos = 0;
        PlayerOwner.ViewTarget.DisplayDebug(self, YL, YPos);

        if (ShouldDisplayDebug('AI') && (Pawn(PlayerOwner.ViewTarget) != None))
        {
            DrawRoute(Pawn(PlayerOwner.ViewTarget));
        }
        return;
    }

    if (bShowAllAI)
    {
        DrawAIOverlays();
    }

    if ( WorldInfo.Pauser != None )
    {
        Canvas.Font = GetFontSizeIndex(2);
        Canvas.Strlen(class'UTGameViewportClient'.default.LevelActionMessages[1],xl,yl);
        Canvas.SetDrawColor(255,255,255,255);
        Canvas.SetPos(0.5*(Canvas.ClipX - XL), 0.44*Canvas.ClipY);
        Canvas.DrawText(class'UTGameViewportClient'.default.LevelActionMessages[1]);
    }

    DisplayLocalMessages();
    DisplayConsoleMessages();

    Canvas.Font = GetFontSizeIndex(1);

    // Check if any remote players are using VOIP
    if ( (CharPRI == None) && (PlayerOwner.VoiceInterface != None) && (WorldInfo.NetMode != NM_Standalone) 
        && (WorldInfo.GRI != None) )
    {
        len = WorldInfo.GRI.PRIArray.Length;
        for ( i=0; i<len; i++ )
        {
            if ( PlayerOwner.VoiceInterface.IsRemotePlayerTalking(WorldInfo.GRI.PRIArray[i].UniqueID) 
                && (WorldInfo.GRI.PRIArray[i] != PlayerOwner.PlayerReplicationInfo) 
                && (UTPlayerReplicationInfo(WorldInfo.GRI.PRIArray[i]) != None) )
            {
                ShowPortrait(UTPlayerReplicationInfo(WorldInfo.GRI.PRIArray[i]));
                break;
            }
        }
    }

    // Draw the character portrait
    if ( CharPRI != None  )
    {
        DisplayPortrait(RenderDelta);
    }

    if ( bShowClock )
    {
        DisplayClock();
    }

    DebugHud("DrawGameHud2");
    
    // If the player isn't dead, draw the living hud
    if ( !UTPlayerOwner.IsDead() )
    {
        DebugHud("DrawGameHud call DrawLivingHud");
            
        DrawLivingHud();       
    }

    if ( bHasMap && bShowMap && ( !bIsSplitScreen || bIsFirstPlayer ) )
    {
        TempResScale = ResolutionScale;
        if (bIsSplitScreen)
        {
            ResolutionScale *=2;
        }
        DisplayMap();
        ResolutionScale = TEmpResScale;
    }

    DisplayDamage();

    if ( bShowQuickPick )
    {
        DisplayQuickPickMenu();
    }
}


/*
   Draw pawns on minimap and corrects certain things.
   
   You can also do this by setting fulldetail to true in UTMapInfo.DrawMap, but it doesn't work well.
   There are so many bugs with that feature:
   Players don't display if on hoverboards.
   Player rotations are pointed wrong direction.
   Opposite team locked vehicles at vehicle factories don't display in single player mode but do in net play.
   Players don't always display in net play due to all kinds of replication issues.
   It uses Pawn array but Pawns only replicate when relevant (near to player).
   It also tries to use PRI array but PRI SetHUDLocation is broke,  PRI HUDPawnLocation, HUDPawnYaw, HUDPawnClass won't
   replicate and don't even get set at server.
   What a mess of broken code.
   To fix for BR we just use our own PlayerManagers which have working replication.
*/
simulated function DrawExtraMapInfo(UTMapInfo MI)
{
    local Pawn P;
    local UTVehicle V;
	local linearcolor FinalColor;
    local UTPlayerReplicationInfo PRI;    
    local int i;
    local UTBRPlayerManager PM;
    local Vector HudLocation;

    //UTMapInfo class only displays ball on minimap if player is on a team,
    //which is not the case for spectator               
    if ((UTOwnerPRI != none) && (UTPlayerOwner != none) && UTOwnerPRI.bOnlySpectator)
    {
        if (TheBall != none)
        {
            TheBall.SetHUDLocation(MI.UpdateHUDLocation(TheBall.Location));
            TheBall.RenderMapIcon(MI, Canvas, UTPlayerOwner);
        }
        
        return;
    }
    
	//highlight ball if held. in UTMapInfo it won't highlight ball if it's held, due to
	//logic for UTOnslaughtFlag be hard coded there so we can't modify the behavior.
	if (
         (UTPlayerOwner.LastAutoObjective != None) &&
         (UTOnslaughtFlag(UTPlayerOwner.LastAutoObjective) != none) && 
         (UTOnslaughtFlag(UTPlayerOwner.LastAutoObjective).HolderPRI != None)
       )
	{
        HudLocation = MI.UpdateHUDLocation(UTPlayerOwner.LastAutoObjective.Location);
        Canvas.SetPos(HudLocation.X - 12*MI.MapScale, HudLocation.Y - 12*MI.MapScale);//*AspectRatio);
        Canvas.SetDrawColor(255,255,0,255 * (1.0-MI.ColorPercent));
        Canvas.DrawTile(class'UTHUD'.default.IconHudTexture,23*MI.MapScale, 23*MI.MapScale, 669,266,75,75);
	}    
          
    ForEach WorldInfo.AllPawns(class'Pawn', P)
    {
        V = UTVehicle(P);
        
        if (V == none)
        {
            continue;
        }
    	
        if ( V.bHidden || (V.Health <=0) || V.IsInvisible() )
    	{
    		continue;
    	}
    	
    	if ((UTPlayerOwner.GetTeamNum() != V.GetTeamNum()) && (! bool(UTBRGame(WorldInfo.Game).Settings.ShowEnemyTeamOnMiniMap)))
        {
            continue;
        } 

    	if ((UTPlayerOwner.GetTeamNum() == V.GetTeamNum()) && (! bool(UTBRGame(WorldInfo.Game).Settings.ShowHomeTeamOnMiniMap)))
        {
            continue;
        }     	

		class'UTHud'.static.GetTeamColor(V.Team, FinalColor);
		V.SetHUDLocation(MI.UpdateHUDLocation(V.Location));
		V.RenderMapIcon(MI, Canvas, UTPlayerOwner, FinalColor);
    }
          
    for (i = 0; i < UTBRGame(WorldInfo.Game).PlayerManagerArray.Length; i++)
    {
        PM = UTBRGame(WorldInfo.Game).PlayerManagerArray[i];
        PRI = UTPlayerReplicationInfo(PM.PlayerReplicationInfo);
        
        if ((PRI == none) || PRI.bOnlySpectator || (PRI.Team == none) ||
            (PlayerOwner.PlayerReplicationInfo == PM.PlayerReplicationInfo) || 
            (! PM.PawnVisibleOnMiniMap))
        {
            continue;
        }
        
    	if ((UTPlayerOwner.GetTeamNum() != PRI.GetTeamNum()) && (! bool(UTBRGame(WorldInfo.Game).Settings.ShowEnemyTeamOnMiniMap)))
        {
            continue;
        } 

    	if ((UTPlayerOwner.GetTeamNum() == PRI.GetTeamNum()) && (! bool(UTBRGame(WorldInfo.Game).Settings.ShowHomeTeamOnMiniMap)))
        {
            continue;
        }         
           
		class'UTHud'.static.GetTeamColor(PRI.Team.TeamIndex, FinalColor);
        HudLocation = MI.UpdateHUDLocation(PM.PawnLocation);        
        MI.DrawRotatedTile(Canvas, class'UTHUD'.default.IconHudTexture, HUDLocation, PM.PawnRotation.Yaw + 16384, class'UTPawn'.default.MapSize, class'UTPawn'.default.IconCoords, FinalColor);
    }
      
}

//modified at //// places from base class for BR. 
/**
 * Draw the Map
 */
function DisplayMap()
{
	local UTMapInfo MI;
	local float ScaleY, W,H,X,Y, ScreenX, ScreenY, XL, YL, OrdersScale, ScaleIn, ScaleAlpha;
	local color CanvasColor;
	local float AdjustedViewportHeight;
	
	
  ////
  if (! bool(UTBRGame(WorldInfo.Game).Settings.DisplayMiniMap))    
  {
      return;
  }

	if ( DisplayedOrders != "" )
	{
		// draw orders
		Canvas.Font = GetFontSizeIndex(2);
		Canvas.StrLen(DisplayedOrders, XL, YL);

		// reduce font size if too big
		if( XL > 0.0f )
		{
			OrdersScale = FMin(1.0, 0.315*Canvas.ClipX/XL);
		}

		// scale in initially
		ScaleIn = FMax(1.0, (0.6+OrderUpdateTime-WorldInfo.TimeSeconds)/0.15);
		ScaleAlpha = FMin(1.0, 4.5 - ScaleIn);
		OrdersScale *= ScaleIn;

		ScreenY = 0.01 * Canvas.ClipY;
		ScreenX = 0.98 * Canvas.ClipX - OrdersScale*XL;

		// first draw drop shadow string
		if ( ScaleIn < 1.1 )
		{
			Canvas.DrawColor = BlackColor;
			Canvas.SetPos( ScreenX+2, ScreenY+2 );
			Canvas.DrawTextClipped( DisplayedOrders, false, OrdersScale, OrdersScale );
		}

		// now draw string with normal color
		Canvas.DrawColor = LightGoldColor;
		Canvas.DrawColor.A = 255 * ScaleAlpha;
		Canvas.SetPos( ScreenX, ScreenY );
		Canvas.DrawTextClipped( DisplayedOrders, false, OrdersScale, OrdersScale );
		Canvas.DrawColor = CanvasColor;
	}

	// draw map
	MI = UTMapInfo( WorldInfo.GetMapInfo() );
	if ( MI != none )
	{
		AdjustedViewportHeight = bIsSplitScreen ? Canvas.ClipY * 2 : Canvas.ClipY;

		ScaleY = AdjustedViewportHeight/768;
		H = MapDefaultSize * ScaleY;
		W = MapDefaultSize * ScaleY;

		X = Canvas.ClipX - (Canvas.ClipX * (1.0 - MapPosition.X)) - W;
		Y = (AdjustedViewportHeight * MapPosition.Y);

		MI.DrawMap(Canvas, UTPlayerController(PlayerOwner), X, Y, W ,H, false, (Canvas.ClipX / AdjustedViewportHeight) );

        ////br
		DrawExtraMapInfo(MI);
	}
}

simulated function SetBall()
{
    if (TheBall == none)
    {
        ForEach WorldInfo.AllActors(class'UTBRBall', TheBall)
        {
            break;
        }       
    }
}

simulated function Timer()
{
    local UTPlayerReplicationInfo PawnOwnerPRI;

    Super(UTTeamHUD).Timer();
 
    //a crude hack to allow the esc key to get out of end game menu back to map.
    //this allows the br scoreboard to be brought up instead of the standard ut3 end game menu scoreboard.
    //also cool to be able to get back to map.
    //see UTPlayerController.ShowScoreboard() as for why this has to be done.
    if (UTBRGame(WorldInfo.Game).GameEnded && (UTGameReplicationInfo(WorldInfo.GRI).CurrentMidGameMenu != none))
    {
        UTGameReplicationInfo(WorldInfo.GRI).bStoryMode = true;
    }
    
    if (! UTBRGame(WorldInfo.Game).GameEnded)
    {
        UTGameReplicationInfo(WorldInfo.GRI).bStoryMode = false;      
    }
    
    SetBall();    

    if ( Pawn(PlayerOwner.ViewTarget) == None )
        return;

    PawnOwnerPRI = UTPlayerReplicationInfo(Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo);

    if ( (PawnOwnerPRI == None)
        || (PlayerOwner.IsSpectating() && UTPlayerController(PlayerOwner).bBehindView) )
    return;

    if (TheBall.PassTarget == PlayerOwner.Pawn)
    {
        PlayerOwner.ReceiveLocalizedMessage( class'UTBRHUDMessage', 3 );        
    }   
    else if (TheBall.IsHeldByEnemyOf(PlayerOwner.Pawn))
    {
        PlayerOwner.ReceiveLocalizedMessage( class'UTBRHUDMessage', 1 );
    }
    else if (TheBall.IsHeldBy(PlayerOwner.Pawn))
    {
        PlayerOwner.ReceiveLocalizedMessage( class'UTBRHUDMessage', 0 );
    }
    else if (TheBall.IsHeldByTeamOf(PlayerOwner.Pawn))
    {
        PlayerOwner.ReceiveLocalizedMessage( class'UTBRHUDMessage', 2 );
    }

}

//display the team graphics at hud top, including ball icons
simulated function DisplayTeamLogos(byte TeamIndex, vector2d POS, optional float DestScale=1.0)
{
    local linearColor Alpha;
    local linearColor TC,Black;
    local float Modifier;
    local color TTC;

    SetBall();
    
    Super(UTTeamHUD).DisplayTeamLogos(TeamIndex, Pos, DestScale);

    GetTeamColor(TeamIndex, TC, TTC);
    Alpha = ColorToLinearColor(LightGoldColor);

    Black.A=1.0;

    TC.A = 1.0;
    Modifier = 1.0 + (0.5 * Abs(cos(WorldInfo.TimeSeconds * 3)));//0.25 + ( 0.75 * Abs(cos(WorldInfo.TimeSeconds * 3)));

    DestScale *= ResolutionScale * 0.7;
    
    if ((TheBall.GetTeamNum() == TeamIndex))
    {

        DestScale *=  Modifier;

        //draw orb icon
        Canvas.SetPos(POS.X - (20 * DestScale), POS.Y - (22*DestScale));
        Canvas.DrawColorizedTile(AltHudTexture,27*DestScale, 27*DestScale,893,37,27,27,TC);

        if (TheBall.IsHeld())
        {
            //draw runner icon
            
            Canvas.SetPos(POS.X-8, POS.Y - (15*DestScale)+2);
            Canvas.DrawColorizedTile(AltHudTexture,40*DestScale , 38*DestScale,843,48,40,38,BLACK);

            Canvas.SetPos(POS.X-6, POS.Y - (15*DestScale));
            Canvas.DrawColorizedTile(AltHudTexture,40*DestScale , 38*DestScale,843,48,40,38,Alpha);     
        }
    }
}

//display the ball radar arrows
simulated function DisplayDirectionIndicator(byte TeamIndex, vector2D POS, Actor DestActor, float DestScale)
{
    local rotator Dir,Angle;
    local vector start;

    if (TheBall.IsHeldBy(PawnOwner))
    {
        return;
    }

    if (TheBall.IsPossessed() && (TheBall.GetTeamNum() != TeamIndex))
    {
        return;
    }    
    
    if ( DestActor != none )
    {
        Start = (PawnOwner != none) ? PawnOwner.Location : UTPlayerOwner.Location;
        Dir  = Rotator(DestActor.Location - Start);
        Angle.Yaw = (Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535;


        // Boost the colors a bit to make them stand out
        Canvas.DrawColor = WhiteColor;
        Canvas.SetPos(POS.X - (28.5 * DestScale * ResolutionScaleX), POS.Y - (26 * DestScale * ResolutionScale));
        Canvas.DrawRotatedTile( AltHudTexture, Angle, 57 * DestScale * ResolutionScaleX, 52 * DestScale * ResolutionScale, 897, 452, 43, 43);
    }
}

//return the actor that the hud radar arrows should be tracking
simulated function Actor GetDirectionalDest(byte TeamIndex)
{
    return TheBall;
}


defaultproperties
{
   bShowDirectional=True
   bShowFragCount=False
   //ScoreboardSceneTemplate=Scoreboard_ONS'UI_Scenes_Scoreboards.sbONS'
   ScoreboardSceneTemplate=UTUIScene_Scoreboard'BombingRunGraphics.BRScoreBoard'   
   MapPosition=(X=0.990000,Y=0.010000)
   Name="Default__UTBRHUD"
   ObjectArchetype=UTCTFHUD'UTGame.Default__UTCTFHUD'
   bHasMap=True
}
